#ifndef WIN32

#ifndef MEETINGMGRCONTROLLERIMPL_H
#define MEETINGMGRCONTROLLERIMPL_H

#include "csfunified/services/impl/base/MeetingMgrControllerBaseImpl.h"
#include "csfunified/services/impl/base/MeetingReminderInfoBaseImpl.h"
#include "services/impl/cmr/CMRControllerDef.h"
#include "../JabberServiceProvider.h"
#include "csf/RWLock.hpp"

#include "sdkwrapper/mac/MeetingSDKWrap.h"

#include "services/impl/MeetingInfoImpl.h"
#include "services/impl/MeetingServiceObjectManager.h"

namespace CSFUnified
{
    
    // deliver type
    enum DELIVER_TYPE
    {
        BY_EMAIL,
        BY_IM
    };
    
    class MeetingCallback;
    class MeetingMgrControllerImpl :
        public MeetingMgrControllerBaseImpl,
        public SMART_PTR_NS::enable_shared_from_this<MeetingMgrControllerImpl>,
        public JM_SDK::IMeetingCalendarEvent
    {
    public:
        MeetingMgrControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory) ;
        
        ~MeetingMgrControllerImpl();
        
        static MeetingMgrControllerImpl * getInstance()
        {
            static MeetingMgrControllerImpl * s_mmController = NULL;
            if (NULL == s_mmController)
            {
                s_mmController = new MeetingMgrControllerImpl(JabberServiceProvider::getInstance().getUnifiedFactory());
            }
            
            return s_mmController;
        }
        
        void start();
        
        void stop();
        
        virtual void registerMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingCallback> meetingCallback);
        virtual void unregisterMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingCallback> meetingCallback);
        
        virtual bool isMeetingInProgress(std::string meetingID);
        
        virtual void getCMRInfo(std::string meetingKeyList);
        virtual unsigned long listMeetings(int year, int month, int day);
        virtual unsigned long refreshMeetings( );
        virtual bool todayChanged(bool bForceChanged);
        virtual unsigned long getMeetingDetail(std::string meetingID);
        virtual unsigned long viewMeetingById(std::string meetingID);
        virtual bool isInMeeting( );
        virtual bool canStartMeeting( );
        virtual bool canJoinMeeting( );
        virtual unsigned long launchMeetingById(std::string meetingID);
        virtual bool startInstantMeeting(std::string meetingName, SMART_PTR_NS::shared_ptr<std::vector<std::string > > vecInviteList);
        virtual bool inviteToInstantMeeting(std::string attendeeName);
        virtual bool acceptInstantMeeting(std::string sessioName);
        virtual bool declineInstantMeeting(std::string sessioName);
        virtual void editInstantMeetingSetting( );
        virtual std::string sendMeetingInvitation(std::string attendees, std::string meetingID, std::string msg);
        virtual void setMeetingReminderEnable(bool isEnable);
        virtual std::string sendMeetingReminder(std::string attendees, std::string meetingID, std::string msg);
        virtual unsigned long sendEmail(std::string tos, std::string subject, std::string body, std::string strMeetingKey);
        virtual int getInstantMeetingLastErrCode( );
        virtual bool startJoinMeetingByUrl(std::string strURL);
        
        virtual MailServiceTypeEnum::MailServiceType getCurrentMailType()
        {
            return MailServiceTypeEnum::NONE;
        }
        virtual bool openMeetingDetailPage(std::string strURL){return false;}
        
        virtual void startCMRMeeting(bool isAutoStart);
        virtual void joinCMRMeeting(std::string siteUrl, std::string meetingKey, std::string mkgtk);
        
        // IMeetingCalendarEvent
        void onMeetingStarted(const PString sessionName, const PString meetingID, bool host);
        void onMeetingEnded(const PString sessionName, const PString meetingID);
        void onMeetingError(const PString sessionName, const PString meetingID, int errCode);
        void onMeetingInvitationReceived(const PString sessionName, const PString meetingTopic);
        void onMeetingInvitationCanceled(const PString sessionName);
        void onMeetingDeclined(const PString sessionName, const PString buddyName);
        void onPopupMeetingWaitDialog();
        void onCloseMeetingWaitDialog();
        void onCmrInfo(const PString cmrInfo);
        void onCmrMeetingStarted(const JM_SDK::CmrMeetingData & meetingInfo);
        void onCmrMeetingJoined();
        void onCmrMeetingEnded();
        void onCmrMeetingError(JM_SDK::INSTANT_MEETING_ERROR_CODE errorCode);
        
        void onCalendarEnabled(bool bEnable);
        void onMeetingEnabled(bool bEnable);
        void onMeetingListed(MeetingCalendarErrorCode errCode);
        void onGetMeetingDetail(const MeetingData& meeting);
        void onMeetingOvernight();
        void onMeetingReminderHappened(const ReminderInfo& reminder);
        void onMeetingReminderUpdated(const ReminderInfo& reminder);
        void onMeetingReminderEnded(const PString meetingID);
        
        void onNetworkConnect();
        void onNetworkDisconnect();
        
        void networkChanged(bool bConnected);
        
    protected:
        DELIVER_TYPE getDeliverType(const std::string& buddyName);
        std::string send(std::string attendees, std::string meetingID, std::string msg, bool reminder);
        void stapleAttendee(const std::string& attendees, std::vector<std::string>& vecEmails, std::vector<std::string>& vecIms);
        std::vector<std::string> sendByEmail(const std::vector<std::string>& vecTos, const std::string& msg, const std::string& meetingID, bool reminder);
        std::vector<std::string> sendByIM(const std::vector<std::string>& vecTos, const std::string& msg, const std::string& meetingID, bool reminder);
        
        void reportMeetingUsage(std::wstring usageStr);
        
        void fireonMeetingStarted(const PString sessionName, const PString meetingID, bool host);
        
    protected:
        MeetingInfoImpl* createMeetingInfoObject(JM_SDK::MeetingData* pData);
        MeetingReminderInfoBaseImpl* createMeetingReminderInfo(const ReminderInfo& reminder);
        CSFUnified::CMRMeetingData createCMRMeetingData(const JM_SDK::CmrMeetingData& meetingData);
        
    public:
        static const unsigned long RET_SUCCEED;
        static const unsigned long RET_FAIL;
        
    private:
        SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
        MeetingCallback* m_meetingCallback;
        bool m_started;
        
        CSFLogger* m_pLogger;
        
        csf::RWLock m_Lock;
        
        MeetingSDKWrap* m_pInstance;
        IInstantMeetingMgr* m_pInstantMeetingMgr;
        IMeetingCalendar* m_pMeetingCalendar;
        IWbxMeetingAccountOperator* m_pAccountOperator;
        
        CSFUnified::MeetingServiceObjectManager* m_pMeetingServiceObjectManager;
    };
    
}

#endif

#endif